#!/usr/bin/python

# TrueRNG Read - Simple Random Number Server Example - Client Side
# Chris K Cockrum
# 8/26/2016
#
# Requires Python 2.7, pyserial
# On Linux - may need to be root or set /dev/tty port permissions to 666
#
# Python 2.7.xx is available here: https://www.python.org/
# Install Pyserial package with:   python -m pip install pyserial

import socket
import sys
import errno

# Port
port = 5555

# Address
#IP = '192.168.1.207'
IP = 'localhost'

try:
	# Create a UDP socket
	sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)

	# Set a timeout to wait (2 seconds)
	sock.settimeout(2.0)

	server_address = (str(IP), int(port))
	message = 'get random'

	# Send data
	#print('Asking for random data')
	sent = sock.sendto(message, server_address)

	# Receive response
	#print('waiting to receive')
	data, server = sock.recvfrom(4096)
	print('received "%s"' % data)

except socket.error, v:
	print('Error: ' + str(v))
	
finally:
	sock.close()