#!/usr/bin/python

# TrueRNG Read - Simple Random Number Server Example - Server Side
# Chris K Cockrum
# 8/26/2016
#
# Requires Python 2.7, pyserial
# On Linux - may need to be root or set /dev/tty port permissions to 666
#
# Python 2.7.xx is available here: https://www.python.org/
# Install Pyserial package with:   python -m pip install pyserial

import socket
import serial
import binascii
from serial.tools import list_ports

# Number of bytes to return
blocksize=64

# Port to listen on
listenport=5555;

# Listen address
#IP = '192.168.1.207'
IP = 'localhost'

# Print our header
print('TrueRNG Server Example')
print('http://ubld.it')
print('==================================================')

# Create ports variable as dictionary
ports=dict()  

# Call list_ports to get com port info 
ports_avaiable = list(list_ports.comports())

# Set default of None for com port
rng_com_port = None

# Loop on all available ports to find TrueRNG
for temp in ports_avaiable:
	if temp[1].startswith("TrueRNG"):
		print('Found:             ' + str(temp))
		if rng_com_port == None:        # always chooses the 1st TrueRNG found
			rng_com_port=str(temp[0])

# Print which port we're using
print('Using com port:    ' + str(rng_com_port))

# Print block size and number of loops
print('Block Size:        ' + str(blocksize) + ' Bytes')
print('==================================================')

	
# Try to setup and open the comport
try:
	ser = serial.Serial(port=rng_com_port,timeout=10)  # timeout set at 10 seconds in case the read fails
except:
	print('Port Not Usable!')
	print('Is a TrueRNG installed?')
	print('Do you have permissions set to read ' + rng_com_port + ' ?')
	
# Open the serial port if it isn't open
if(ser.isOpen() == False):
	ser.open()

# Set Data Terminal Ready to start flow
ser.setDTR(True)   

# This clears the receive buffer so we aren't using buffered data
ser.flushInput()    

# Keep track of total bytes read
totalbytes=0

# Create a TCP/IP socket
sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)

# Bind the socket to the port
server_address = (str(IP), listenport)
print('Listening on port '+ str(server_address[1]))
sock.bind(server_address)

try:
	while True:

		# Wait for connection and get data
		data, address = sock.recvfrom(4096)
		
		# print('Received "' + data +'" from ' + address[0])
			
		# If we received the correct command
		if data == 'get random':
		
			# Read bytes from serial port and convert to an ASCII hex string
			randdata=binascii.hexlify(bytearray(ser.read(blocksize)))   
			
			# Send data back to requestor
			sent = sock.sendto(randdata, address)
			print('Sent %s characters (%s Random bytes) to %s' % (sent, str(blocksize), address[0]))

finally:		

	# Close the socket
	sock.close()
	
	# Close the serial port
	ser.close()
